<?php
require "classdb.php";
$con = new Database(); 
ini_set('display_errors', 1);
error_reporting(E_ALL);
 

// =====================
// RECEIVE DATA
// =====================
$member_no   = trim($_POST['member_no'] ?? '');
$trans_type  = trim($_POST['trans_type'] ?? '');
$amount      = trim($_POST['amount'] ?? '');
$trans_date = $_POST['saving_date'] ?? '';
$description = trim($_POST['description'] ?? '');

// =====================
// SERVER-SIDE VALIDATION
// =====================
if (
    $member_no === '' ||
    $trans_type === '' ||
    $amount === '' ||
    $trans_date === ''
) {
    exit('<div class="alert alert-danger">All required fields must be filled</div>');
}

if (!is_numeric($amount) || $amount < 500) {
    exit('<div class="alert alert-danger">Invalid amount</div>');
}

try {
    // =====================
    // CHECK MEMBER EXISTS
    // =====================
    $chk = $con->getValidateID($member_no);

    if ($chk->rowCount() == 0) {
        exit('<div class="alert alert-danger">Member not found</div>');
    }

    // =====================
    // CALCULATE CURRENT BALANCE
    // =====================
    $balance = $con->getBalance($member_no);
      

    // =====================
    // WITHDRAW PROTECTION
    // =====================
    if ($trans_type === 'WITHDRAW' && $amount > $balance) {
        exit('<div class="alert alert-danger">Insufficient balance</div>');
    }

    // =====================
    // INSERT TRANSACTION
    // =====================
   $stmt = $con->depositSavings($member_no, $amount, $trans_type,$trans_date,$description,$by);

    // =====================
    // SUCCESS MESSAGE
    // =====================
    echo '<div class="alert alert-success">Transaction saved successfully</div>';

} catch (PDOException $e) {
    echo '<div class="alert alert-danger">Error: '.$e->getMessage().'</div>';
}


/*if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $member_id       = $_POST['member_id'];
    $saving_type     = $_POST['saving_type'];
    $amount          = $_POST['amount'];
    $transaction_date= $_POST['transaction_date'];
    $reference_no    = trim($_POST['reference_no']);

    // check duplicate (same member, reference_no)
    $check = $db->getThisSaving($id_number,$email,$phone); 

    if ($check->rowCount() > 0) {
        echo "<div class='alert alert-danger'>Duplicate saving record found</div>";
    } else {
        if ($db->insertSaving($member_id,$saving_type,$amount,$transaction_date,$reference_no)) {
            echo "<div class='alert alert-success'>Saving recorded successfully</div>";
        } else {
            echo "<div class='alert alert-danger'>Failed to record saving</div>";
        }
    }
}
*/