<?php
require "classdb.php";
$con = new Database();

 
ini_set('display_errors', 1);
error_reporting(E_ALL);
 

// === Receive data ===
$memberNo = trim($_POST['member_no'] ?? '');
$fullname  = trim($_POST['fullname'] ?? '');
$phone     = trim($_POST['phone'] ?? '');
$idNo     = trim($_POST['id_no'] ?? '');
$join_date = $_POST['join_date'] ?? '';
$status    = $_POST['status'] ?? '';
$user    = $_POST['user'] ?? '';

// === Basic validation ===
if (
    $memberNo === '' ||
    $fullname === '' ||
    $phone === '' ||
    $idNo === '' ||
    $join_date === '' ||
    $status === ''
) {
    exit('<div class="alert alert-danger">All fields are required</div>');
}

// === Phone validation (TZ format) ===
if (!preg_match('/^0[0-9]{9}$/', $phone)) {
    exit('<div class="alert alert-danger">Invalid phone number</div>');
}

try {
    // === Check duplicates ===
    $check=$con->getThisMember($id_no,$phone);
    if ($check->rowCount() > 0) { 
        exit('<div class="alert alert-warning">Member already exists</div>');
    }

    // === Insert member ===
    $stmt = $con->insertMember($memberNo,$join_date, $fullname, $phone, $idNo,$by);

    echo '<div class="alert alert-success">Member saved successfully</div>';

} catch (PDOException $e) {
    echo '<div class="alert alert-danger">Error: '.$e->getMessage().'</div>';
}





/*if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $fname  = trim($_POST['fname']);
    $mname  = trim($_POST['mname']);
    $lname  = trim($_POST['lname']);
    $gender = $_POST['gender'];
    $dob    = $_POST['dob'];
    $email  = trim($_POST['email']);
    $phone  = trim($_POST['phone']);
    $id_number = trim($_POST['id_number']);
    $join_date = $_POST['join_date'];
    $status = $_POST['status'];

    // check duplication (id_number OR email OR phone must be unique)
    $check=$db->getThisMember($id_number,$email,$phone);
    if ($check->rowCount() > 0) {
        echo "<div class='alert alert-danger'>Member already exists (duplicate email/phone/ID)</div>";
    } else {
        if ($db->insertMember($fname,$mname,$lname,$gender,$dob,$email,$phone,$id_number,$join_date,$status)) {
            echo "<div class='alert alert-success'>Member registered successfully</div>";
        } else {
            echo "<div class='alert alert-danger'>Failed to register member</div>";
        }
    }
}
*/
