<?php
require "classdb.php";
$con = new Database();
/* =========================
   BASIC SERVER VALIDATION
========================= */
if (
    empty($_POST['member_no']) ||
    empty($_POST['loan_type']) ||
    empty($_POST['principal']) ||
    empty($_POST['interest_rate']) ||
    empty($_POST['period_months']) ||
    empty($_POST['status']) ||
    empty($_POST['application_date'])
) {
    echo "<div class='alert alert-danger'>All required fields must be filled.</div>";
    exit;
}

/* =========================
   CLEAN INPUT
========================= */
$member_no         = trim($_POST['member_no']);
$loan_type         = trim($_POST['loan_type']);
$principal         = floatval($_POST['principal']);
$interest_rate     = floatval($_POST['interest_rate']);
$period_months     = intval($_POST['period_months']);
$status            = trim($_POST['status']);
$application_date  = $_POST['application_date'];
$approval_date     = !empty($_POST['approval_date']) ? $_POST['approval_date'] : null;
$disbursement_date = !empty($_POST['disbursement_date']) ? $_POST['disbursement_date'] : null;

/* =========================
   DUPLICATE CHECK FUNCTION
========================= */
$check=$con->loanExists($member_no, $loan_type, $application_date);

 
/* =========================
   CHECK DUPLICATION
========================= */
if ($check->rowCount()>0) {
    echo "<div class='alert alert-warning'>
            Loan application already exists for this member on this date.
          </div>";
    exit;
}

/* =========================
   INSERT LOAN APPLICATION
========================= */
try {
    $check=$con->insertLoanApplication($member_no,$loan_type,$principal,$interest_rate,$period_months,$status,$application_date,$approval_date,$disbursement_date);

    echo "<div class='alert alert-success'>
            Loan application submitted successfully.
          </div>";

} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>
            System error: ".$e->getMessage()."
          </div>";
}
