<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
//include('auth.php'); 
?>
<!DOCTYPE html>
<html>
<head>
    <title>SACCOS Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
          min-height: 100vh;
          display: flex;
          flex-direction: column;
          background-color: #f8f9fa;
        }
        main { flex: 1; }

        /* Sidebar */
        .sidebar {
          height: 100vh;
          padding-top: 20px;
          background: #0d1b2a;
          color: #fff;
        }
        .sidebar h5 {
          color: #fff;
        }

        /* Accordion buttons transparent border */
        .sidebar .accordion-button {
          background: #0d1b2a !important;
          color: #fff !important;
          border: none !important;
        }
        .sidebar .accordion-button:focus {
          box-shadow: none !important;
        }
        .sidebar .accordion-button:not(.collapsed) {
          background: #1b263b !important;
          border: none !important;
        }

        /* Accordion body */
        .sidebar .accordion-body {
          background: #1b263b !important;
          border: none !important;
        }

        /* Sidebar nav links */
        .sidebar .nav-link {
          color: #fff !important;
          border: none !important;
        }
        .sidebar .nav-link:hover {
          background-color: #415a77 !important;
        }

        /* Dashboard Cards */
        .card {
          border-radius: 16px;
          box-shadow: 0 6px 12px rgba(0,0,0,0.1);
        }

        /* Footer */
        .footer {
          text-align: center;
          padding: 10px;
          background: #0d1b2a;
          color: #fff;
          font-size: 14px;
          margin-top: 20px;
        }

        /* User Input & Date */
        #user {
          width: 200px;
        }
        #sdate {
          width: 160px;
        }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background: #0d1b2a; /* dark blue shade */
            color: white;
            text-align: center;
            padding: 10px 0;
            font-size: 14px;
            z-index: 1000; /* keeps footer above other elements */
  }
  .nav-link {
  color: #0d6eff !important;
}

.nav-link:hover {
  color: #66b2ff !important;
  text-decoration: underline;
}

    </style>
</head>

<body>
<!-- Navbar -->
<nav class="navbar navbar-expand-xxl bg-dark navbar-dark">
  <div class="container-fluid">
    <span class="navbar-text text-white fw-bold mx-auto">
      SACCOS MANAGEMENT SYSTEM
    </span>
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" href="index.php">Logout</a>
      </li>
    </ul>
  </div>
</nav>
  Yes<?php //echo $_SESSION['user']; ?>
<!-- User & Date Row -->
 <!-- Date input fixed top-right -->
<div style="position: absolute; top: 70px; right: 20px; z-index: 1030;">
  <input type="date" class="form-control" 
         style="width: 160px;" 
         id="sdate" name="sdate" 
         value="<?php echo date("Y-m-d"); ?>">
</div>
<small><h6 id="ds" class="mt-1"></h6></small>
  

<div class="container-fluid">
   
  <div class="row">
    <!-- Sidebar -->
    <nav class="col-md-2 d-none d-md-block sidebar">
       
      <h5 class="px-3 mt-3">Menu</h5>
      <div class="accordion" id="sidebarMenu">

        <!-- Registration -->
        <div class="accordion-item" style="border:none;">
          <h2 class="accordion-header" id="headingReg">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseReg">
              Registration
            </button>
          </h2>
          <div id="collapseReg" class="accordion-collapse collapse" data-bs-parent="#sidebarMenu">
            <div class="accordion-body p-0">
              <ul class="nav flex-column">
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="smembergf.php">Members</a></li>
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="savingtb.php">Savings</a></li>
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="loantb.php">Loans</a></li>
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="loanpayrec.php">Loans payment</a></li>
              </ul>
            </div>
          </div>
        </div>
        
        
          <!-- Accounts -->
        <div class="accordion-item" style="border:none;">
          <h2 class="accordion-header" id="headingAcc">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAcc">
              Accounting
            </button>
          </h2>
          <div id="collapseAcc" class="accordion-collapse collapse" data-bs-parent="#sidebarMenu">
            <div class="accordion-body p-0">
              <ul class="nav flex-column">
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="chartOfAccount.php">Accounts</a></li>
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="journalEntryForm.php">Journal entry</a></li>
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="integrationLogForm.php">integration Log Form</a></li>
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="loanpayrec.php">Loans payment</a></li>
              </ul>
            </div>
          </div>
        </div>

        <!-- Reports -->
        <div class="accordion-item" style="border:none;"  >
          <h2 class="accordion-header" id="headingReports">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseReports">
              Reports
            </button>
          </h2>
          <div id="collapseReports" class="accordion-collapse collapse" data-bs-parent="#sidebarMenu">
            <div class="accordion-body p-0">
              <ul class="nav flex-column">
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="usersList.php">Member records</a></li>
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="vehicleR.php">Savings Report</a></li>
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="serviceR.php">Loan Report</a></li>
              </ul>
            </div>
          </div>
        </div>

        <!-- Actions / Delete -->
        <div class="accordion-item" style="border:none;">
          <h2 class="accordion-header" id="headingActions">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseActions">
              Actions / Delete
            </button>
          </h2>
          <div id="collapseActions" class="accordion-collapse collapse" data-bs-parent="#sidebarMenu">
            <div class="accordion-body p-0">
              <ul class="nav flex-column">
                <li class="nav-item"><a href="#" class="nav-link load-page" data-page="deldriverpayR.php">Update/Delete Loan</a></li>
              </ul>
            </div>
          </div>
        </div>

      </div>
    </nav>

    <!-- Main Content -->
    <main class="col-md-10 ms-sm-auto px-md-4 py-4">
      <div id="content-area">
        <!-- Dashboard Cards -->
        <div class="row g-4">
          <div class="col-md-3 col-6">
            <div class="card text-center p-3">
              <h6>Total Members</h6>
              <h3>120</h3>
            </div>
          </div>
          <div class="col-md-3 col-6">
            <div class="card text-center p-3">
              <h6>Total Savings</h6>
              <h3>1,250,000</h3>
            </div>
          </div>
          <div class="col-md-3 col-6">
            <div class="card text-center p-3">
              <h6>Active Loans</h6>
              <h3>45</h3>
            </div>
          </div>
          <div class="col-md-3 col-6">
            <div class="card text-center p-3">
              <h6>Pending Reports</h6>
              <h3>5</h3>
            </div>
          </div>
        </div>

        <!-- Recent Activities Table -->
        <div class="card mt-4 p-3">
          <h5>Recent Activities</h5>
          <table class="table table-striped">
            <thead>
              <tr>
                <th>Date</th>
                <th>Activity</th>
                <th>Member</th>
                <th>Amount</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>2025-10-01</td>
                <td>Loan Disbursed</td>
                <td>John Doe</td>
                <td>500,000</td>
              </tr>
              <tr>
                <td>2025-09-28</td>
                <td>Savings Deposit</td>
                <td>Mary Smith</td>
                <td>50,000</td>
              </tr>
              <tr>
                <td>2025-09-25</td>
                <td>Loan Repayment</td>
                <td>Peter Wilson</td>
                <td>30,000</td>
              </tr>
            </tbody>
          </table>
        </div>

        <!-- Footer -->
        

      </div>
      <div class="footer">
          &copy; <span id="year"></span> SACCOS System. All rights reserved.
        </div>
   
  
    </main>
  </div>
</div>

<script>
  document.getElementById("year").textContent = new Date().getFullYear();

  $(document).ready(function() {
    $(".load-page").click(function(e) {
      e.preventDefault();
      const page = $(this).data("page");
      $("#content-area").load(page);
    });
  });
</script>
</body>
</html>
