<div class="container-fluid px-2 px-md-4 mt-3">
  <div id="loanMsg"></div>

  <div class="bg-white text-dark rounded shadow-sm p-3 p-md-4">
    <h6 class="mb-3 text-center text-md-start">Loan Application</h6>

    <!-- MEMBER -->
    <div class="row g-2">
      <div class="col-12 col-md-6 col-lg-4">
        <label class="form-label">Member No</label>
        <input type="number" class="form-control" id="member_no" placeholder="Member number">
        <sup class="text-danger" id="lm"></sup>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <label class="form-label">Loan Type</label>
        <select class="form-control" id="loan_type">
          <option value="">Select type</option>
          <option value="Personal">Personal</option>
          <option value="Business">Business</option>
          <option value="Emergency">Emergency</option>
        </select>
        <sup class="text-danger" id="lt"></sup>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <label class="form-label">Principal Amount</label>
        <input type="number" class="form-control" id="principal" placeholder="Amount">
        <sup class="text-danger" id="pr"></sup>
      </div>
    </div>

    <!-- LOAN DETAILS -->
    <div class="row g-2 mt-2">
      <div class="col-12 col-md-6 col-lg-4">
        <label class="form-label">Interest Rate (%)</label>
        <input type="number" class="form-control" id="interest_rate" placeholder="e.g 12">
        <sup class="text-danger" id="ir"></sup>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <label class="form-label">Period (Months)</label>
        <input type="number" class="form-control" id="period_months" placeholder="Months">
        <sup class="text-danger" id="pm"></sup>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <label class="form-label">Status</label>
        <select class="form-control" id="status">
          <option value="Pending">Pending</option>
          <option value="Approved">Approved</option>
          <option value="Disbursed">Disbursed</option>
          <option value="Rejected">Rejected</option>
        </select>
        <sup class="text-danger" id="st"></sup>
      </div>
    </div>

    <!-- DATES -->
    <div class="row g-2 mt-2">
      <div class="col-12 col-md-6 col-lg-4">
        <label class="form-label">Application Date</label>
        <input type="date" class="form-control" id="application_date"
               value="<?php echo date('Y-m-d'); ?>">
        <sup class="text-danger" id="ad"></sup>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <label class="form-label">Approval Date</label>
        <input type="date" class="form-control" id="approval_date">
        <sup class="text-danger" id="apd"></sup>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <label class="form-label">Disbursement Date</label>
        <input type="date" class="form-control" id="disbursement_date">
        <sup class="text-danger" id="dd"></sup>
      </div>
    </div>

    <!-- BUTTON -->
    <div class="mt-4">
      <button type="button"
              class="btn btn-primary w-100 w-md-auto"
              style="height:48px;"
              onclick="saveLoan()">
        Submit Loan
      </button>
    </div>

  </div>
</div>


<script>
function saveLoan(){
  var ecc=0;
  var member_no = $("#member_no").val().trim();
  var loan_type = $("#loan_type").val();
  var principal = $("#principal").val().trim();
  var interest_rate = $("#interest_rate").val().trim();
  var period_months = $("#period_months").val().trim();
  var status = $("#status").val();
  var application_date = $("#application_date").val();
  var approval_date = $("#approval_date").val();
  var disbursement_date = $("#disbursement_date").val();

  if(member_no==""){ ecc++; $("#lm").html("Required"); } else { $("#lm").html(""); }
  if(loan_type==""){ ecc++; $("#lt").html("Required"); } else { $("#lt").html(""); }
  if(principal==""){ ecc++; $("#pr").html("Required"); } else { $("#pr").html(""); }
  if(interest_rate==""){ ecc++; $("#ir").html("Required"); } else { $("#ir").html(""); }
  if(period_months==""){ ecc++; $("#pm").html("Required"); } else { $("#pm").html(""); }
  if(application_date==""){ ecc++; $("#ad").html("Required"); } else { $("#ad").html(""); }

  if(ecc==0){
    $.post("process_loan.php", {
      member_no:member_no,
      loan_type:loan_type,
      principal:principal,
      interest_rate:interest_rate,
      period_months:period_months,
      status:status,
      application_date:application_date,
      approval_date:approval_date,
      disbursement_date:disbursement_date
    }, function(data){
      $("#loanMsg").html(data).show();
    });
  }
}
</script>
-->
