<div class="container mt-3" style="width:100%;">
  <div id="journalMsg"></div>
  <div class="mt-4 p-5 bg-white text-dark rounded">
    <h6>Journal Entry:</h6>

    <div class="row">
      <div class="col">
        <label for="account_id">Account ID:</label>
        <input type="number" class="form-control" id="account_id" placeholder="Enter Account ID" required>
        <sup class="text-danger" id="aid"></sup>
      </div>

      <div class="col">
        <label for="debit">Debit Amount:</label>
        <input type="number" class="form-control" id="debit" placeholder="Enter debit amount" value="0">
      </div>

      <div class="col">
        <label for="credit">Credit Amount:</label>
        <input type="number" class="form-control" id="credit" placeholder="Enter credit amount" value="0">
      </div>
    </div>

    <div class="row mt-3">
      <div class="col">
        <label for="entry_date">Entry Date:</label>
        <input type="date" class="form-control" id="entry_date" value="<?php echo date('Y-m-d'); ?>" required>
      </div>
      <div class="col">
        <label for="reference_no">Reference No:</label>
        <input type="text" class="form-control" id="reference_no" placeholder="Enter Reference No">
      </div>
    </div>

    <div class="row mt-3">
      <div class="col">
        <label for="narration">Narration:</label>
        <textarea class="form-control" id="narration" rows="2" placeholder="Brief description of transaction"></textarea>
      </div>
    </div>

    <div class="mt-3 text-end">
      <button type="button" class="btn btn-primary" onclick="saveJournal()">Submit</button>
    </div>
  </div>
</div>

<script>
function saveJournal(){
  var ecc=0;
  var account_id=$("#account_id").val().trim();
  var debit=$("#debit").val().trim();
  var credit=$("#credit").val().trim();
  var entry_date=$("#entry_date").val();
  var reference_no=$("#reference_no").val().trim();
  var narration=$("#narration").val().trim();

  if(account_id==""){ecc++;$("#aid").html("Required");}else{$("#aid").html("");}

  if(ecc==0){
    $.post("processJournalEntry.php",{
      account_id:account_id,
      debit:debit,
      credit:credit,
      entry_date:entry_date,
      reference_no:reference_no,
      narration:narration
    },function(data){
      $("#journalMsg").html(data).show();
    });
  }
}
</script>
