<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SACCOS Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #2c3e50, #3498db);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }
    .login-card {
      max-width: 400px;
      margin: auto;
      border-radius: 20px;
      box-shadow: 0 8px 20px rgba(0,0,0,0.2);
    }
    .footer {
      margin-top: auto;
      text-align: center;
      color: #fff;
      padding: 15px;
      font-size: 14px;
    }
  </style>
</head>
<body>

  <!-- Login Card -->
  <div class="container d-flex align-items-center justify-content-center" style="min-height: 90vh;">
    <div class="card login-card p-4">
      <h3 class="text-center mb-4">SACCOS Login</h3>
      <form>
        <div class="mb-3">
          <label for="email" class="form-label">Email or Phone</label>
          <input type="text" class="form-control" id="email" placeholder="Enter email or phone">
        </div>
        <div class="mb-3">
          <label for="password" class="form-label">Password</label>
          <input type="password" class="form-control" id="password" placeholder="Enter password">
        </div>
        <div class="d-flex justify-content-between mb-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" id="remember">
            <label class="form-check-label" for="remember">Remember me</label>
          </div>
          <a href="#" class="small">Forgot Password?</a>
        </div>
        <button type="submit" class="btn btn-primary w-100">Login</button>
      </form>
      
    </div>
  </div>

  <!-- Footer -->
  <div class="footer">
    &copy; <span id="year"></span> Your SACCOS System. All rights reserved.
  </div>

  <script>
    document.getElementById("year").textContent = new Date().getFullYear();
  </script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
