<?php
class Database {
    
     public  $pdo;
     public  $host="localhost";
     public  $dbname="budacotz_saccosdb";
     public  $user="budacotz_sac";
     public  $pwd="sac@cos2025";
     


                                      //FUNCTION FOR DATABASE CONNECTION GOES HERE
 
function __construct(){

            $this->dbcon = new PDO("mysql:dbname=$this->dbname;host=$this->host;",$this->user,$this->pwd);
          
}
  public function getThisMember($idNo,$phone)
  {
    $stmt = $this->pdo->prepare("SELECT * FROM members WHERE id_no = :id_number OR  phone = :phone");
    $check= $stmt->execute(["id_number"=>$idNo,"phone"=>$phone]);
    return  $check;
}

  public function getThisSaving($member_id,$reference_no)
  {
    $stmt = $this->pdo->prepare("SELECT * FROM savings WHERE member_id = :member_id AND reference_no = :ref");;
    
    $check=$stmt->execute(["member_id"=>$member_id,"ref"=>$reference_no]);
    return  $check;
}

  public function getThisLoanPay($loan_id)
  {
    $stmt = $this->pdo->prepare("SELECT * FROM loans WHERE id = :loan_id");
    
    $check=$stmt->execute(["id"=>$loan_id]);
    return  $check;
}

  public function getThisLoan($member_no,$loan_type,$application_date)
  {
    $stmt = $this->pdo->prepare("SELECT * FROM loans WHERE member_no=:member_id AND loan_type=:loan_type AND application_date=:app_date");
    
    $check=$stmt->execute(["member_no"=>$member_no,"loan_type"=>$loan_type,"app_date"=>$application_date]);
    return  $check;
}
 public function getBalance($member_no)
  {
    $stmt = $this->pdo->prepare("
        SELECT 
          COALESCE(SUM(
            CASE 
              WHEN trans_type IN ('SAVING','SHARES','REG_FEE','PENALTY')
              THEN amount
              ELSE -amount
            END
          ),0) AS balance
        FROM savings
        WHERE member_no = ?
    ");
    $check=$stmt->execute(["member_no"=>$member_no]);
    $balance = $check->fetchColumn();
    
    
    return  $balance;
}
  public function getValidateID($member_no)
  {
    $stmt = $this->pdo->prepare("SELECT * FROM members WHERE member_no=:member_no");
    
    $check=$stmt->execute(["member_no"=>$member_no]);
    return  $check;
}
    /* ============= INSERT FUNCTIONS ============= */

    // 1. Insert Member
   function insertMember($memberNo,$join_date, $fullname, $phone, $idNo,$by) {
    $sql = "INSERT INTO members(member_no, fullname, phone, id_no, join_date, status,rby)
            VALUES (:member_no, :fullname, :phone, :id_no, :join_date,:rby, 'ACTIVE')";

    $stmt = $this->pdo->prepare($sql);
    return $stmt->execute([
        ':member_no' => $memberNo,
        ':fullname'  => $fullname,
        ':phone'     => $phone,
        ':id_no'     => $idNo,
        ':join_date' => $join_date,
        ':rby'     => $by
    ]);
}
function approveLoan($loanId) {
    $sql = "UPDATE loans SET status='APPROVED' WHERE loan_id=:loan_id";
    $stmt = $this->pdo->prepare($sql);
    return $stmt->execute([':loan_id' => $loanId]);
}


    // 2. Insert Saving
  function depositSavings($member_no, $amount, $trans_type,$trans_date,$description,$by) {
    $sql = "INSERT INTO savings(member_no, amount, trans_type, trans_date,description,rby)
            VALUES (:member_no, :amount, :trans_type, :trans_date,:description,:rby)";

    $stmt = $this->pdo->prepare($sql);
    return $stmt->execute([
        ':member_no' => $member_no,
        ':amount'    => $amount,
        ':trans_type'=>$trans_type,
        ':trans_date'=>$trans_date,
        ':description'=>$description,
        ':rby'=>$by
    ]);
}


    // 3. Insert Loan
    
    function insertLoanApplication($member_no,$loan_type,$principal,$interest_rate,$period_months,$status,$application_date,$approval_date,$disbursement_date)
{
    try {
        $sql = "INSERT INTO loans 
                (member_no, loan_type, principal, interest_rate, period_months, status,
                 application_date, approval_date, disbursement_date)
                VALUES 
                (:member_no, :loan_type, :principal, :interest_rate, :period_months, :status,
                 :application_date, :approval_date, :disbursement_date)";

        $stmt = $this->pdo->prepare($sql);

        $stmt->bindParam(':member_no', $data['member_no']);
        $stmt->bindParam(':loan_type', $data['loan_type']);
        $stmt->bindParam(':principal', $data['principal']);
        $stmt->bindParam(':interest_rate', $data['interest_rate']);
        $stmt->bindParam(':period_months', $data['period_months']);
        $stmt->bindParam(':status', $data['status']);
        $stmt->bindParam(':application_date', $data['application_date']);
        $stmt->bindParam(':approval_date', $data['approval_date']);
        $stmt->bindParam(':disbursement_date', $data['disbursement_date']);

        return $stmt->execute();

    } catch (PDOException $e) {
        return "Error: " . $e->getMessage();
    }
}

function loanExists($member_no, $loan_type, $application_date)
{
    $sql = "SELECT COUNT(*) 
            FROM loans 
            WHERE member_no = :member_no 
              AND loan_type = :loan_type
              AND application_date = :application_date";

    $stmt = $this->pdo->prepare($sql);
    $stmt->execute([
        ':member_no' => $member_no,
        ':loan_type' => $loan_type,
        ':application_date' => $application_date
    ]);

    return $stmt->fetchColumn();
}
 
function insertLoanRepayment($loan_id, $amount, $date_paid)
{
    try {
        // 1. Fetch current loan details
        $stmt = $this->pdo->prepare("SELECT principal, interest_rate, period_months, status FROM loans WHERE id = :loan_id");
        $stmt->execute([':loan_id' => $loan_id]);
        $loan = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$loan) {
            return "Loan not found.";
        }

        // 2. Calculate total already paid
        $stmt2 = $this->pdo->prepare("SELECT SUM(amount) as total_paid FROM loan_repayments WHERE loan_id = :loan_id");
        $stmt2->execute([':loan_id' => $loan_id]);
        $total_paid = $stmt2->fetchColumn();
        $total_paid = $total_paid ? $total_paid : 0;

        // 3. Calculate loan total (simplified: principal + interest)
        $total_loan_amount = $loan['principal'] + ($loan['principal'] * $loan['interest_rate'] / 100);

        // 4. Prevent overpayment
        if (($total_paid + $amount) > $total_loan_amount) {
            return "Payment exceeds remaining loan balance.";
        }

        // 5. Insert repayment
        $insert = $this->pdo->prepare("INSERT INTO loan_repayments (loan_id, amount, date_paid) 
                                 VALUES (:loan_id, :amount, :date_paid)");
        $insert->execute([
            ':loan_id'   => $loan_id,
            ':amount'    => $amount,
            ':date_paid' => $date_paid
        ]);

        return true;

    } catch (PDOException $e) {
        return "Database error: " . $e->getMessage();
    }
}


    function withdrawSavings($memberId, $amount) {
    $sql = "INSERT INTO savings(member_id, amount, trans_type, trans_date)
            VALUES (:member_id, :amount, 'WITHDRAW', CURDATE())";

    $stmt = $this->pdo->prepare($sql);
    return $stmt->execute([
        ':member_id' => $memberId,
        ':amount'    => $amount
    ]);
}

 

    // 4. Insert Repayment
    function repayLoan($db, $loanId, $amount) {
    $sql = "INSERT INTO loan_repayments(loan_id, amount, pay_date)
            VALUES (:loan_id, :amount, CURDATE())";

    $stmt = $db->prepare($sql);
    return $stmt->execute([
        ':loan_id' => $loanId,
        ':amount'  => $amount
    ]);
}


    /* ============= RETRIEVAL FUNCTIONS ============= */
    
   
    public function addAccount($account_name, $account_code, $type, $parent_id = null, $status = 'Active') {
        $check = $this->pdo->prepare("SELECT * FROM chart_of_accounts WHERE account_code=?");
        $check->execute([$account_code]);
        if ($check->rowCount() > 0) {
            return "❌ Account code already exists!";
        }

        $sql = "INSERT INTO chart_of_accounts (account_name, account_code, type, parent_account_id, status, created_at, time)
                VALUES (?, ?, ?, ?, ?, CURDATE(), CURTIME())";
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute([$account_name, $account_code, $type, $parent_id, $status]);
        return "✅ Account created successfully!";
    }

    /* 📑 JOURNAL ENTRY (Header + Lines) */
    public function addJournalEntry($entry_date, $description, $posted_by, $lines = []) {
        // Insert header
        $stmt = $this->pdo->prepare("INSERT INTO journal_entries (entry_date, description, posted_by, created_at, time) 
                                     VALUES (?, ?, ?, CURDATE(), CURTIME())");
        $stmt->execute([$entry_date, $description, $posted_by]);
        $journal_id = $this->pdo->lastInsertId();

        // Insert each line
        $lineStmt = $this->pdo->prepare("INSERT INTO journal_lines (journal_id, account_id, debit, credit, created_at, time) 
                                         VALUES (?, ?, ?, ?, CURDATE(), CURTIME())");
        foreach ($lines as $line) {
            $lineStmt->execute([$journal_id, $line['account_id'], $line['debit'], $line['credit']]);
        }

        return "✅ Journal entry added successfully!";
    }

    /* 🔗 INTEGRATION LOG */
    public function addIntegrationLog($integration_type, $reference_no, $response_status, $message) {
        $sql = "INSERT INTO integration_logs (integration_type, reference_no, response_status, message, created_at, time)
                VALUES (?, ?, ?, ?, CURDATE(), CURTIME())";
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute([$integration_type, $reference_no, $response_status, $message]);
        return "✅ Integration log recorded.";
    }

    /* 🧾 AUDIT TRAIL */
    public function addAudit($user_id, $action, $description, $table_name, $record_id, $ip_address) {
        $sql = "INSERT INTO audit_trail (user_id, action, description, table_name, record_id, ip_address, created_at, time)
                VALUES (?, ?, ?, ?, ?, ?, CURDATE(), CURTIME())";
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute([$user_id, $action, $description, $table_name, $record_id, $ip_address]);
        return "✅ Audit logged.";
    }
 
 
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
    
    

    public function getMembers() {
        return $this->pdo->query("SELECT * FROM members ORDER BY creat_at DESC")->fetchAll();
    }

    public function getSavingsByMember($member_id) {
        $stmt = $this->pdo->prepare("SELECT * FROM savings WHERE member_id = :member_id ORDER BY creat_at DESC");
        $stmt->execute(["member_id"=>$member_id]);
        return $stmt->fetchAll();
    }

    public function getLoansByMember($member_id) {
        $stmt = $this->pdo->prepare("SELECT * FROM loans WHERE member_id = :member_id ORDER BY creat_at DESC");
        $stmt->execute(["member_id"=>$member_id]);
        return $stmt->fetchAll();
    }

    public function getRepaymentsByLoan($loan_id) {
        $stmt = $this->pdo->prepare("SELECT * FROM repayments WHERE loan_id = :loan_id ORDER BY creat_at DESC");
        $stmt->execute(["loan_id"=>$loan_id]);
        return $stmt->fetchAll();
    }
    /////////////////////////////////////////////NEW VERSION//////////////
    
    function insertMember($db, $memberNo, $fullname, $phone, $idNo) {
    $sql = "INSERT INTO members(member_no, fullname, phone, id_no, join_date, status)
            VALUES (:member_no, :fullname, :phone, :id_no, CURDATE(), 'ACTIVE')";

    $stmt = $db->prepare($sql);
    return $stmt->execute([
        ':member_no' => $memberNo,
        ':fullname'  => $fullname,
        ':phone'     => $phone,
        ':id_no'     => $idNo
    ]);
}

    
    
    
    
    
}
