<div class="container mt-3" style="width:100%;">
  <div id="accountMsg"></div>
  <div class="mt-4 p-5 bg-white text-dark rounded">
    <h6>Chart of Accounts:</h6>

    <div class="row">
      <div class="col">
        <label for="account_name">Account Name:</label>
        <input type="text" class="form-control" id="account_name" 
               placeholder="e.g., Cash, Savings, Interest Income" required>
        <sup class="text-danger" id="an"></sup>
      </div>

      <div class="col">
        <label for="account_type">Account Type:</label>
        <select class="form-control" id="account_type" required>
          <option value="">Select Type</option>
          <option value="Asset">Asset</option>
          <option value="Liability">Liability</option>
          <option value="Equity">Equity</option>
          <option value="Income">Income</option>
          <option value="Expense">Expense</option>
        </select>
        <sup class="text-danger" id="at"></sup>
      </div>
    </div>

    <div class="row mt-3">
      <div class="col">
        <label for="description">Description:</label>
        <textarea class="form-control" id="description" rows="2" placeholder="Short description..."></textarea>
      </div>
    </div>

    <div class="row mt-3">
      <div class="col">
        <label for="created_date">Created Date:</label>
        <input type="date" class="form-control" id="created_date" 
               value="<?php echo date('Y-m-d'); ?>" required>
      </div>
    </div>

    <div class="mt-3 text-end">
      <button type="button" class="btn btn-primary" onclick="saveAccount()">Submit</button>
    </div>
  </div>
</div>

<script>
function saveAccount(){
  var ecc=0;
  var account_name=$("#account_name").val().trim();
  var account_type=$("#account_type").val();
  var description=$("#description").val().trim();
  var created_date=$("#created_date").val();

  if(account_name==""){ecc++;$("#an").html("Required");}else{$("#an").html("");}
  if(account_type==""){ecc++;$("#at").html("Required");}else{$("#at").html("");}

  if(ecc==0){
    $.post("processChartAccount.php",{
      account_name:account_name,
      account_type:account_type,
      description:description,
      created_date:created_date
    },function(data){
      $("#accountMsg").html(data).show();
    });
  }
}
</script>
