<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require_once "labClass.php";
$con = new labClass();

$cID        = $_GET['cID'] ?? null;
$type       = $_GET['type'] ?? 'both'; // deposit | withdraw | both
$startDate  = $_GET['start_date'] ?? null;
$endDate    = $_GET['end_date'] ?? null;

// --- Prepare customer list for datalist ---
$customers = $con->getCus()->fetchAll(PDO::FETCH_ASSOC);

// --- Opening balance ---
$openingDeposits = 0;
$openingWithdrawals = 0;
$openingBalance = 0;

if (!empty($cID)) {
    $openDepo = $con->genOpeningDepo($cID, $startDate);
    $openingDeposits = $openDepo ? ($openDepo->fetchColumn() ?? 0) : 0;

    $openWith = $con->genOpeningWith($cID, $startDate);
    $openingWithdrawals = $openWith ? ($openWith->fetchColumn() ?? 0) : 0;

    $openingBalance = $openingDeposits - $openingWithdrawals;
}

// --- Main transactions ---
$transactions = [];
if (!empty($cID)) {
    $stmt = $con->genBothTrans($type, $startDate, $endDate, $cID);
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// --- Compute running balance ---
$runningBalance = $openingBalance;
foreach ($transactions as &$txn) {
    $runningBalance += $txn['amount'];
    $txn['balance'] = $runningBalance;
}
unset($txn);
$closingBalance = $runningBalance;
$cn=$con->getThisCusBId($cID)->fetch();
?>
 
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<style>
.custom-blue-border, .custom-blue-border th, .custom-blue-border td {
  border: 1px solid #007bff !important;
}
.deposit { color: green; font-weight: 600; }
.withdraw { color: red; font-weight: 600; }
.negative-balance { color: red; font-weight: bold; }
.table-warning td, .table-info td { font-weight: bold; }
</style>
</head>
 


<div class="container mb-3" >
    <h3 class="mb-3 text-primary"><?php echo $cn['cname'];?>'s Statement</h3>
<?php if (!empty($cID)): ?>
<table class="table table-bordered custom-blue-border">
  <thead class="table-light">
    <tr>
      <th>Date</th>
      <th>Description</th>
      <th>Deposit</th>
      <th>Withdraw</th>
      <th>Balance</th>
    </tr>
  </thead>
  <tbody>
    <!-- Opening balance -->
    <tr class="table-warning">
      <td colspan="4" class="text-end"><strong>Opening Balance:</strong></td>
      <td><strong><?= number_format($openingBalance, 2) ?></strong></td>
    </tr>

    <?php if (empty($transactions)): ?>
      <tr><td colspan="5" class="text-center text-muted">No transactions found.</td></tr>
    <?php else: ?>
      <?php foreach ($transactions as $txn): ?>
        <tr>
          <td><?= htmlspecialchars($txn['tdate']) ?></td>
          <td><?= htmlspecialchars($txn['description']) ?></td>
          <td class="deposit"><?= $txn['amount'] > 0 ? number_format($txn['amount'], 2) : '' ?></td>
          <td class="withdraw"><?= $txn['amount'] < 0 ? number_format(abs($txn['amount']), 2) : '' ?></td>
          <td class="<?= $txn['balance'] < 0 ? 'negative-balance' : '' ?>">
            <?= number_format($txn['balance'], 2) ?>
          </td>
        </tr>
      <?php endforeach; ?>
    <?php endif; ?>

    <tr class="table-info">
      <td colspan="4" class="text-end"><strong>Closing Balance:</strong></td>
      <td><strong><?= number_format($closingBalance, 2) ?></strong></td>
    </tr>
  </tbody>
</table>
<?php else: ?>
  <div class="alert alert-info">Please select a customer to view their statement.</div>
<?php endif; ?>
 
