<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$cc=0;
$sdate=$_POST['sdate'] ?? null;
require_once "labClass.php";
$con = new labClass();

$startDate = $_GET['start_date'] ?? null;
$endDate   = $_GET['end_date'] ?? null;

$whereMiamala = $whereOther = $whereWithdraw = "";
$stmt= $con->genStatement($whereOther,$whereMiamala,$whereWithdraw,$startDate,$endDate);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC); 

$statement = [];
$runningBalance = 0; // Global running balance

foreach ($rows as $row) {
    $date = $row['tdate'];
    $amt  = $row['amount'];

    if (!isset($statement[$date])) {
        $statement[$date] = [
            'date' => $date,
            'transactions' => []
        ];
    }

    $runningBalance += $amt;
    $row['globalBalance'] = $runningBalance;

    $statement[$date]['transactions'][] = $row;
}

// Final global balance
$netAmount = $runningBalance;
?>
<!DOCTYPE html>
<html>
<head>
    <title>Bank Statement Report</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
   <style>
  /* thin blue line between transactions */
  .txn-sep td {
    border-top: 1px solid #007bff !important;
    padding: 0 !important;
  }

  /* bold blue line between dates */
  .date-sep td {
    border-top: 4px solid #007bff !important;
    padding: 0 !important;
  }
  .custom-blue-border, 
  .custom-blue-border th, 
  .custom-blue-border td {
      border: 1px solid #007bff !important; /* Bootstrap primary blue */
  }
  @media print {
    .txn-sep td { border-top: 1px solid #007bff !important; }
    .date-sep td { border-top: 4px solid #007bff !important; }
  }
</style>
</head>
<body class="p-4">
<div id="pr" class="row g-3 mb-3">
    <h2 class="mb-3">Bank Statement Report</h2>

    <!-- Date range form -->
    <div class="row g-3 mb-3">
        <div class="col-auto">
            <label class="form-label">Start Date</label>
            <input type="date" id="start_date" name="start_date" value="<?= htmlspecialchars($startDate ?? '') ?>" class="form-control">
        </div>
        <div class="col-auto">
            <label class="form-label">End Date</label>
            <input type="date" id="end_date" name="end_date" value="<?= htmlspecialchars($endDate ?? '') ?>" class="form-control">
        </div>
        <div class="col-md-2">
            <button type="submit" onclick="var sdate=$('#sdate').val(); var start_date=$('#start_date').val(); var end_date=$('#end_date').val();  $.get('transStatementBdt.php',{sdate:sdate,start_date:start_date,end_date:end_date},function(data){$('#dpl').html(data).show();});" class="btn btn-primary">Generate</button>
        </div>
   
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary" value="Print" style="width:30%; height:40px;" onclick="printPageArea();">Print</button>
        </div>
    </div>

<div id="dpl">
<table class="table table-bordered custom-blue-border">
    <thead class="table-light">
        <tr>
            <th>Date</th>
            <th>Description</th>
            <th>Debit</th>
            <th>Credit</th>
            <th>Balance</th>
        </tr>
    </thead>
    <tbody>
        <?php if (empty($statement)): ?>
            <tr>
                <td colspan="5" class="text-center text-muted">No records found for selected range</td>
            </tr>
        <?php else: ?>
            <?php foreach ($statement as $day): ?>
                <?php foreach ($day['transactions'] as $i => $txn): ?>
                <tr>
                    <?php if ($i === 0): ?>
                        <td rowspan="<?= count($day['transactions']) ?>"><?= htmlspecialchars($day['date']) ?></td>
                    <?php endif; ?>
                    <td><?= htmlspecialchars($txn['description']) ?></td>
                    <td class="text-success">
                        <?= $txn['amount'] > 0 ? number_format($txn['amount'], 2) : '' ?>
                    </td>
                    <td class="text-danger">
                        <?= $txn['amount'] < 0 ? number_format(abs($txn['amount']), 2) : '' ?>
                    </td>
                    <td><?= number_format($txn['globalBalance'], 2) ?></td>
                </tr>
                <?php endforeach; ?>
                <!-- Bold blue dashed separator row -->
                <tr class="date-sep"><td colspan="5"></td></tr>
            <?php endforeach; ?>
        <?php endif; ?>
    </tbody>
    <tfoot>
        <tr class="table-info">
            <th colspan="4" class="text-end">Global Net Balance Remaining:</th>
            <th><?= number_format($netAmount, 2) ?></th>
        </tr>
    </tfoot>
</table>
</div>
</div>
</body>
</html>

<script type="text/javascript">
  function printPageArea(){
    var printContent = document.getElementById('pr').innerHTML;
    var originalContent = document.body.innerHTML;
    document.body.innerHTML = printContent;
    window.print();
    document.body.innerHTML = originalContent;
}
</script>
