<?php
require_once "labClass.php";
$con = new labClass();
?>

<div class="container mt-3">
  <div class="mt-4 p-5 bg-white text-dark rounded shadow-sm border">
    <h6 class="fw-bold text-primary">CASH & EXPENSE REGISTRATION FORM</h6>
    <sub id="dis"></sub>

    <div class="row">
      <!-- Category -->
      <div class="col">
        <label class="form-label">Select Type:</label>
        <select class="form-select" name="category" id="category">
          <option value="">Select</option>
          <option value="Cash">Cash (Income)</option>
          <option value="Expense">Expense</option>
        </select>
        <sup class="text-danger" id="catErr"></sup>
      </div>

      <!-- Source -->
      <div class="col">
        <label class="form-label">Source / Expense Title:</label>
        <input type="text" class="form-control" id="source" placeholder="Enter source or expense title">
        <sup class="text-danger" id="sourceErr"></sup>
      </div>
    </div>

    <div class="row mt-2">
      <!-- Amount -->
      <div class="col">
        <label class="form-label">Amount:</label>
        <input type="number" class="form-control" id="amount" placeholder="Enter amount">
        <sup class="text-danger" id="amtErr"></sup>
      </div>

      <!-- Date -->
      <div class="col">
        <?php
        $today = date("Y-m-d");
        $yesterday = date("Y-m-d", strtotime("-1 day"));
        ?>
        <label class="form-label">Date:</label>
        <input type="date" class="form-control" id="cdate" value="<?= $today ?>" min="<?= $yesterday ?>" max="<?= $today ?>">
      </div>
    </div>

    <div class="row mt-3">
      <!-- Description -->
     <div class="col">
     <table class="table table-borderless align-middle">
  <tr>
    <td width="70%">
      <label class="form-label">Description (optional):</label>
      <textarea id="description" class="form-control" rows="2"></textarea>
    </td>
    <td width="30%">
      <label for="entryDate" class="form-label">Date:</label>
      <input type="date" id="entryDate" name="entryDate" class="form-control" value="<?php echo date('Y-m-d'); ?>">
    </td>
  </tr>
</table>

</div>


      <div class="col d-flex align-items-end">
        <button type="button" id="submit" class="btn btn-primary w-50" onclick="saveCashExp()">Submit</button>
      </div>
    </div>
  </div>
</div>

<div id="reportArea"></div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function saveCashExp() {
  var err = 0;

  var category = $('#category').val().trim();
  var source = $('#source').val().trim();
  var amount = $('#amount').val().trim();
  var sdate = $('#cdate').val().trim();
   var idate = $('#entryDate').val().trim();
  var user = $('#user').val().trim();
  var description = $('#description').val().trim()+' TAREHE:'+idate;
  var submit = $('#submit').val();

  if (category == "") { $('#catErr').text("Category required!"); err++; } else { $('#catErr').text(""); }
  if (source == "") { $('#sourceErr').text("Source required!"); err++; } else { $('#sourceErr').text(""); }
  if (amount == "") { $('#amtErr').text("Amount required!"); err++; } else { $('#amtErr').text(""); }

  if (err == 0) {
    $.post("cash_expenses_process.php",
      {category: category, source: source,user:user, amount: amount, sdate: sdate, description: description, submit: submit},
      function(data) {
        $('#dis').html(data).show();
       // loadReport(); // auto-refresh report
      }
    );
    $('#category').val('');
    $('#source').val('');
    $('#amount').val('');
    $('#description').val('');
  }
}

 
</script>
